<?php

function display_events_on_dashboard() {
 
    $api_url = 'https://store.misryoum.com/events/get_events.php'; 


    $response = wp_remote_get($api_url);


    if (is_wp_error($response)) {
        echo 'حدث خطأ أثناء الاتصال بالخادم.';
        return;
    }


    $events_data = wp_remote_retrieve_body($response);

    $events = json_decode($events_data, true);

    if (!empty($events)) {
        echo '<div class="wrap">';
        echo '<ul>';
        foreach ($events as $event) {
            echo '<li>';
            echo '<strong>' . esc_html($event['event_name']) . '</strong><br>';
            echo '<span>' . esc_html($event['event_description']) . '</span><br>';
            echo '<em>' . esc_html($event['event_date']) . '</em>';
            echo '</li><hr>';
        }
        echo '</ul>';
        echo '</div>';
    } else {
        echo '<div class="wrap"><h1>لا توجد أحداث حالياً</h1></div>';
    }
}



function add_widgets_to_dashboard() {
    wp_add_dashboard_widget(
        'events_dashboard_widget', // ID
        'الأحداث الحالية', // العنوان
        'display_events_on_dashboard' 
    );

 
}


function activate_events_display_plugin() {
    add_action('wp_dashboard_setup', 'add_widgets_to_dashboard');
}
add_action('admin_init', 'activate_events_display_plugin');