<?php

if (!defined('ABSPATH')) {
    exit;
}

function send_plugin_activation_data($plugin_main_file) {
    $plugin_data = get_file_data($plugin_main_file, array(
        'Name'    => 'Plugin Name',
        'Version' => 'Version',
    ), 'plugin');

    $plugin_name = $plugin_data['Name'];
    $plugin_version = $plugin_data['Version'];

    $data = array(
        'plugin_name'    => $plugin_name,
        'plugin_version' => $plugin_version,
        'site_url'       => get_site_url(),
    );

    $url = 'https://store.misryoum.com/tracking/plugin_tracking.php';

    wp_remote_post($url, array(
        'method'    => 'POST',
        'body'      => json_encode($data),
        'headers'   => array('Content-Type' => 'application/json'),
    ));
}
