<?php
define('PLUGIN_SLUG', 'store-plugin');
define('PLUGIN_VERSION', '2.0');
define('UPDATE_CHECK_URL', 'https://store.misryoum.com/update/api/check-update.php');

function check_for_plugin_update_notice() {
    $response = wp_remote_get(UPDATE_CHECK_URL . '?plugin=' . urlencode(PLUGIN_SLUG));

    if (is_wp_error($response) || wp_remote_retrieve_response_code($response) != 200) {
        return;
    }

    $update_data = json_decode(wp_remote_retrieve_body($response), true);

    if (isset($update_data['new_version']) && version_compare(PLUGIN_VERSION, $update_data['new_version'], '<')) {
        $plugin_name = isset($update_data['name']) ? esc_html($update_data['name']) : 'إضافة متجر الاضافات';
        $update_version = esc_html($update_data['new_version']);
        $update_description = isset($update_data['description']) ? esc_html($update_data['description']) : 'لا يوجد وصف';
        $download_url = isset($update_data['update_url']) ? esc_url($update_data['update_url']) : '#';

        add_action('admin_notices', function() use ($plugin_name, $update_version, $update_description, $download_url) {
            ?>
            <div class="notice notice-warning is-dismissible">
                <p>
                    <strong>تحديث جديد للإضافة "<?php echo $plugin_name; ?>" متاح!</strong><br>
                    الإصدار الحالي: <strong><?php echo PLUGIN_VERSION; ?></strong><br>
                    الإصدار الجديد: <strong><?php echo $update_version; ?></strong><br>
                    <strong>وصف التحديث:</strong> <?php echo $update_description; ?><br>
                    <a href="<?php echo $download_url; ?>" class="button button-primary" target="_blank">تحميل التحديث الآن</a>
                </p>
            </div>
            <?php
        });
    } else {
    }
}
add_action('admin_init', 'check_for_plugin_update_notice');