<?php
/**
* Plugin Name: المتحر الاضافات الجيل الثانى
 * Plugin URI: https://misryoum.com
 * Description: المتجر الإضافات العربية - أعمال الإضافات لـ عمار العمرانى.
 * Version: 2.0
 * Author: عمار العمرانى
 * Author URI: https://www.facebook.com/amar.alamrany
 * License: GPL2
 * Text Domain: store-plugin
 */

if (!defined('ABSPATH')) {
    exit;
}

define('STORE_PLUGIN_DIR', plugin_dir_path(__FILE__));
define('STORE_PLUGIN_URL', plugin_dir_url(__FILE__));

function store_plugin_include_files() {
    $files = [
        'includes/update-notice.php',
        'includes/tracking.php',
        'includes/getevents.php',
    ];

    foreach ($files as $file) {
        $path = plugin_dir_path(__FILE__) . $file;
        if (file_exists($path)) {
            require_once $path;
        }
    }
}
store_plugin_include_files();

function store_plugin_load_files($hook) {
    if ($hook === 'toplevel_page_store-plugin') {
        wp_enqueue_style('store-style', STORE_PLUGIN_URL . 'assets/css/store-style.css');
        wp_enqueue_script('store-script', STORE_PLUGIN_URL . 'assets/js/store-script.js', ['jquery'], null, true);
    }
}
add_action('admin_enqueue_scripts', 'store_plugin_load_files');

function store_plugin_add_menu() {
    add_menu_page(
        __('متجر الإضافات', 'store-plugin'),
        __('متجر الإضافات', 'store-plugin'),
        'manage_options',
        'store-plugin',
        'store_plugin_display_plugins',
        'dashicons-store',
        25
    );
}
add_action('admin_menu', 'store_plugin_add_menu');

function store_plugin_display_plugins() {
    include_once plugin_dir_path(__FILE__) . 'templates/display-plugins.php';
}

add_action('wp_ajax_install_plugin', function () {
    if (!current_user_can('install_plugins')) {
        return;
    }

    $download_url = isset($_POST['download_url']) ? esc_url_raw($_POST['download_url']) : '';

    if (empty($download_url)) {
        return;
    }

    require_once ABSPATH . 'wp-admin/includes/file.php';
    require_once ABSPATH . 'wp-admin/includes/misc.php';
    require_once ABSPATH . 'wp-admin/includes/class-wp-upgrader.php';
    require_once ABSPATH . 'wp-admin/includes/plugin.php'; 

    $upgrader = new Plugin_Upgrader(new Automatic_Upgrader_Skin());
    $result = $upgrader->install($download_url);

    if (is_wp_error($result)) {
        return;
    }

    $plugin_file = $upgrader->plugin_info(); 
    if (!empty($plugin_file)) {
        $activate = activate_plugin($plugin_file);

        if (is_wp_error($activate)) {
            return;
        }
    } else {
        return;
    }
});

if (function_exists('send_plugin_activation_data')) {
    register_activation_hook(__FILE__, function() {
        send_plugin_activation_data(__FILE__);
    });
}

add_filter('plugin_action_links_' . plugin_basename(__FILE__), function($links) {
    $store_url = admin_url('admin.php?page=store-plugin');
    $links[] = '<a href="' . esc_url($store_url) . '" style="color: #ff4500;">' . __('المتجر', 'store-plugin') . '</a>';
    return $links;
});