<?php

if (!defined('ABSPATH')) {
    exit;
}

require_once ABSPATH . 'wp-admin/includes/plugin.php';

// جلب البيانات من API
function fetch_plugins_from_api() {
    $api_url = 'https://store.misryoum.com/store/public/get_plugins.php';
    $response = wp_remote_get($api_url);

    if (is_wp_error($response)) {
        return [];
    }

    $body = wp_remote_retrieve_body($response);
    $data = json_decode($body, true);

    if ($data['status'] === 'success') {
        return $data['data'];
    }

    return [];
}

// ترتيب الإضافات بترتيب تنازلي حسب ID
function sort_plugins_by_id_desc($plugins) {
    usort($plugins, function ($a, $b) {
        return $b['id'] - $a['id']; // ترتيب تنازلي
    });
    return $plugins;
}

$plugins = fetch_plugins_from_api();
$plugins = sort_plugins_by_id_desc($plugins); // ترتيب الإضافات

$installed_plugins = get_plugins();

// تضمين سكربت JavaScript
function store_plugin_enqueue_scripts() {
    wp_enqueue_script('store-plugin-js', plugin_dir_url(__FILE__) . 'assets/js/install-plugin.js', array('jquery'), null, true);
}
add_action('admin_enqueue_scripts', 'store_plugin_enqueue_scripts');
?>

<div class="wrap">
    <h1>متجر الإضافات</h1>

    <div class="notification">
        <p>جميع الإضافات في المتجر محدثة. إذا كنت تستخدم إصدارًا قديمًا، يمكنك الآن تثبيت الإصدار الحديث.</p>
    </div>
    <input type="text" id="search-input" placeholder="ابحث عن إضافة..." style="width: 100%; margin-bottom: 20px; padding: 8px; font-size: 14px;">

    <h2>جميع الإضافات</h2>
    <?php if (!empty($plugins)): ?>
        <table class="widefat fixed" style="margin-top: 20px; width: 100%;">
            <thead>
                <tr>
                    <th style="width: 5%;">ID</th>
                    <th style="width: 20%;">اسم الإضافة</th>
                    <th style="width: 35%;">وصف الإضافة</th>
                    <th style="width: 10%;">الإصدار</th>
                    <th style="width: 10%;">التعليمات</th>
                    <th style="width: 10%;">التحميل</th>
                    <th style="width: 10%;">الحالة</th>
                </tr>
            </thead>
            <tbody id="plugin-table-body">
                <?php foreach ($plugins as $plugin): 
                    $is_installed = false;
                    $plugin_basename = '';
                    
                    foreach ($installed_plugins as $plugin_file => $plugin_data) {
                        if (strpos($plugin_file, basename($plugin['install_url'], '.zip')) !== false) {
                            $is_installed = true;
                            $plugin_basename = $plugin_file;
                            break;
                        }
                    }
                ?>
                    <tr class="plugin-row">
                        <td><?php echo esc_html($plugin['id']); ?></td>
                        <td><?php echo esc_html($plugin['name']); ?></td>
                        <td><?php echo esc_html($plugin['description']); ?></td>
                        <td><?php echo esc_html($plugin['version']); ?></td>
                        <td>
                            <a href="<?php echo esc_url($plugin['help_url']); ?>" target="_blank" class="button">التعليمات</a>
                        </td>
                        <td>
                            <a href="<?php echo esc_url($plugin['download_url']); ?>" target="_blank" class="button">تحميل</a>
                        </td>
                        <td>
                            <?php if ($is_installed): ?>
                                <span style="color: red; font-weight: bold;">مثبت</span>
                            <?php else: ?>
                                <button 
                                    class="button install-plugin" 
                                    data-download-url="<?php echo esc_url($plugin['install_url']); ?>">تثبيت</button>
                            <?php endif; ?>
                        </td>
                    </tr>
                <?php endforeach; ?>
            </tbody>
        </table>
    <?php else: ?>
        <p>لا توجد إضافات متاحة حاليًا.</p>
    <?php endif; ?>
</div>

<script type="text/javascript">
jQuery(document).ready(function($) {
    // البحث
    $('#search-input').on('input', function() {
        var searchTerm = $(this).val().toLowerCase();
        
        var filteredPlugins = <?php echo json_encode($plugins); ?>.filter(function(plugin) {
            return (
                plugin.name && plugin.name.toLowerCase().includes(searchTerm) ||
                plugin.description && plugin.description.toLowerCase().includes(searchTerm)
            );
        });

        var resultHtml = '';
        filteredPlugins.forEach(function(plugin) {
            resultHtml += '<tr>';
            resultHtml += '<td>' + plugin.id + '</td>';
            resultHtml += '<td>' + plugin.name + '</td>';
            resultHtml += '<td>' + plugin.description + '</td>';
            resultHtml += '<td>' + plugin.version + '</td>';
            resultHtml += '<td><a href="' + plugin.help_url + '" target="_blank" class="button">التعليمات</a></td>';
            resultHtml += '<td><a href="' + plugin.download_url + '" target="_blank" class="button">تحميل</a></td>';
            resultHtml += '<td>' + (plugin.is_installed ? '<span style="color: red; font-weight: bold;">مثبت</span>' : '<button class="button install-plugin" data-download-url="' + plugin.install_url + '">تثبيت</button>') + '</td>';
            resultHtml += '</tr>';
        });

        $('#plugin-table-body').html(resultHtml);
    });

    // تثبيت الإضافة
    $(document).on('click', '.install-plugin', function() {
        const button = $(this);
        const downloadUrl = button.data('download-url');

        button.text('جارٍ التثبيت...').prop('disabled', true);

        $.ajax({
            url: ajaxurl,
            type: 'POST',
            data: {
                action: 'install_plugin',
                download_url: downloadUrl
            },
            success: function(response) {
                if (response.success) {
                    button.replaceWith('<span style="color: red; font-weight: bold;">مثبت</span>');
                } else {
                    button.replaceWith('<span style="color: red; font-weight: bold;">مثبت</span>');
                }
            },
            error: function(xhr, status, error) {
                button.replaceWith('<span style="color: red; font-weight: bold;">مثبت</span>');
            }
        });
    });
});
</script>